/** Florian Royer - IMA4 - Projet Maison communicante
 *
 * Compilation :
 * gcc -I /usr/include/libxml2 -o parser $(mysql_config --cflags) parser.c $(mysql_config --libs) -Wall -lxml2
 *
 */

#include "parser.h"

#ifdef LIBXML_TREE_ENABLED

// Variables Globales
char user[30],host[30],pass[30],DB[30], date[8];

// Fonction permettant de récupérer les infos user, host, password et DB qui sont dans le fichier de configuration
void Recup_Info_SQL(char* fichier)
{
  FILE *fd;

  fd=fopen(fichier,"r");
  if (fd==NULL)
  {
      printf("erreur ouverture\n");
  }
  else {
      fscanf(fd,"<?php\n\n$machine='%s\n$user='%s\n$pwd='%s\n$db='%s\n",host,user,pass,DB);

  }

  int j=0;
  for (j = 0; j < 30; j++)
  {
      if (host[j]=='\'')
      {
          host[j]='\0';
      }
  }
  j=0;
  for (j = 0; j < 30; j++)
  {
      if (user[j]=='\'')
      {
          user[j]='\0';
      }
  }
  j=0;
  for (j = 0; j < 30; j++)
  {
      if (pass[j]=='\'')
      {
          pass[j]='\0';
      }
  }
  j=0;
  for (j = 0; j < 30; j++)
  {
      if (DB[j]=='\'')
      {
          DB[j]='\0';
      }
  }
}

// Fonction permettant de récupérer la date de la machine dans date[8]
void now(char date[8]){
    time_t secondes;
    struct tm instant;
    time(&secondes);
    instant=*localtime(&secondes);
    //Différenciation si le mois commence par 1, 12 par exemple pour décembre
    if (instant.tm_mon<9) sprintf(date,"%d0%d%d", instant.tm_year+1900,instant.tm_mon+1, instant.tm_mday);
    else sprintf(date,"%d%d%d", instant.tm_year+1900,instant.tm_mon+1, instant.tm_mday);
}

// Fonction d'insert de la température et heure dans la BdD
void insert_meteo2bdd(int temperature, char datetime[25]){
    MYSQL mysql;
    mysql_init(&mysql);
    char tmp[512];
    char tmp2[512];
    sprintf(tmp,"INSERT INTO METEO VALUES ('%s','%d')",datetime,temperature);
    sprintf(tmp2,"DELETE * FROM METEO");
    if(mysql_real_connect(&mysql,host,user,pass,DB,0,NULL,0)) {
        mysql_query(&mysql,tmp2);
        mysql_query(&mysql,tmp);
        mysql_close(&mysql);    
    }
    else {
        printf("Une erreur s est produite lors de la connexion à la BDD!\n");
        printf("Voici le message d'erreur : %s\n\n",mysql_error(&mysql));
    }
}

// Fonction permettant de parcourir le XML
static void print_element_names(char date[8],char day[8], char hour[8], int temp_num, xmlNode * a_node){
    xmlNode *cur_node = NULL;
    char temp[2];
    time_t secondes;
    struct tm instant;
    time(&secondes);
    instant=*localtime(&secondes);
    char dateSQL[25];
    for (cur_node = a_node;
	cur_node;
	cur_node = cur_node->next)
    {
        if (cur_node->type == XML_ELEMENT_NODE) {
            if (strcmp((char *)cur_node->name, "day")==0){ //ne récupère que les balises day
                xmlAttrPtr attr = xmlHasProp(cur_node, (xmlChar *)"value");
                if(attr != NULL) sprintf(day,"%s",xmlGetProp(cur_node, (xmlChar *)"value"));
            }

            if (strcmp((char *)day,(char *)date)==0) //on continue à parser uniquement si la date du site correspond à la date la machine
            {
                if (strcmp((char *)cur_node->name, "hour")==0){ //récupèration de l'heure
                    xmlAttrPtr attr = xmlHasProp(cur_node, (xmlChar *)"value");
                    if (attr != NULL) sprintf(hour,"%s:00", xmlGetProp(cur_node, (xmlChar *)"value"));
                }       
                if (strcmp((char *)cur_node->name, "temp")==0){ // et de la température associée
                    xmlAttrPtr attr = xmlHasProp(cur_node, (xmlChar *)"value");
                    if(attr != NULL) {
                        sprintf(temp,"%s", xmlGetProp(cur_node, (xmlChar *)"value"));
                        if (temp != NULL && strcmp(hour,"24:00:00")!=0)
                        {
                            temp_num = atoi (temp);
                            if (instant.tm_mon<9){
                                sprintf(dateSQL , "%d-0%d-%d %s",instant.tm_year+1900,instant.tm_mon+1, instant.tm_mday, hour);
                            }
                            else sprintf(dateSQL , "%d-%d-%d %s",instant.tm_year+1900,instant.tm_mon+1, instant.tm_mday, hour);
                            insert_meteo2bdd(temp_num , dateSQL);
                        }
                    }
                }
            }
            print_element_names(date, day, hour, temp_num, cur_node->children);   
	   }
    }
}

//Fonction pour afficher la vue View_temp_piece
void read_temp_AVG()
{
  MYSQL mysql;
  mysql_init(&mysql);
  mysql_options(&mysql,MYSQL_READ_DEFAULT_GROUP,"option");

  if(mysql_real_connect(&mysql,host,user,pass,DB,0,NULL,0))
    {
    //Déclaration des pointeurs de structure
    MYSQL_RES *result = NULL;
    MYSQL_ROW row = NULL;

    unsigned int i = 0;
    unsigned int num_champs = 0;

    //requête qui sélectionne tout dans la vue
    mysql_query(&mysql, "SELECT * FROM View_temp_piece");
    result = mysql_use_result(&mysql);

    //On récupère le nombre de champs
    num_champs = mysql_num_fields(result);

    // On boucle sur chaque ligne
    while (( row =  mysql_fetch_row(result)))
      {
      //On déclare un pointeur long non signé pour y stocker la taille des valeurs
      unsigned long *lengths;
      //On stocke cette taille dans le pointeur
      lengths = mysql_fetch_lengths(result);
      //On fait une boucle pour avoir la valeur de chaque champs de la ligne
      for(i = 0; i < num_champs; i++)
        {
        //On ecrit toutes les valeurs
        printf("%.*s  ", (int) lengths[i], row[i] ? row[i] : "NULL");
        }
      printf("\n");
      }
    //Libération du jeu de résultat
    mysql_free_result(result);
    //Fermeture de MySQL
    mysql_close(&mysql);
    }
  else
    {
      printf("Une erreur s est produite lors de la connexion à la BDD!\n");
      printf("Voici le message d'erreur : %s\n\n",mysql_error(&mysql));
    }
}

//Fonction pour insérer une température dans la BDD, paramètres : ID du capteur et Température en float
void insert_temp2DB(unsigned char adresse[20], float temperature)
{
  MYSQL mysql;
  mysql_init(&mysql);
  char tmp[512];
  sprintf(tmp,"INSERT INTO SENSOR VALUES ('%s',NOW(),'%f');",adresse,temperature);
  if(mysql_real_connect(&mysql,host,user,pass,DB,0,NULL,0)) {
    mysql_query(&mysql,tmp);
    mysql_close(&mysql);    
  }
  else {
    printf("Une erreur s est produite lors de la connexion à la BDD!\n");
    printf("Voici le message d'erreur : %s\n\n",mysql_error(&mysql));
  }
}   

int execute(){
    Recup_Info_SQL("/var/www/projet/include/database.params.inc");
    now(date);
    MYSQL mysql;
    mysql_init(&mysql);
    mysql_options(&mysql,MYSQL_READ_DEFAULT_GROUP,"option");

    if(mysql_real_connect(&mysql,host,user,pass,DB,0,NULL,0))
    {
        //Déclaration des pointeurs de structure
        MYSQL_RES *result = NULL;

        char query[256];
        sprintf(query,"SELECT * FROM METEO WHERE DATE_FORMAT(m_time, GET_FORMAT(DATE, 'INTERNAL')) = %s", date);

        //requête qui sélectionne tout dans la vue
        mysql_query(&mysql, query);
        result = mysql_use_result(&mysql);
        if (mysql_fetch_row(result)==NULL) // Récupère l'adresse météo et parse
        {
          char day[8], hour[8];
          int temp_num=0;
          xmlDoc *doc = NULL;
          xmlNode *root_element = NULL;

          // Ouvre le fichier contenant l'info météo
          char s[256];
          FILE *fd = fopen("/var/www/projet/config/station.conf", "r");
       
          while (fgets(s, 256, fd) != NULL) printf ("%c \n", s[1]);

          fclose(fd);

          // Test du XmlDoc
          LIBXML_TEST_VERSION

          /*parse the file and get the DOM */

          char* meteo_file = malloc(1024);
          snprintf(meteo_file, 1024, "%s%c%c%c%c%c%s", "http://api.tameteo.com/index.php?api_lang=fr&localidad=", s[0],s[1],s[2],s[3],s[4],"&affiliate_id=4m5k1yq8ozbe&v=2.0&h=1");

          doc = xmlReadFile(meteo_file, NULL, 0);

          /*Get the root element node */
          root_element = xmlDocGetRootElement(doc);

          print_element_names(date, day, hour, temp_num, root_element);

          /*free the document */
          xmlFreeDoc(doc);

          xmlCleanupParser();

        }

        //Libération du jeu de résultat
        mysql_free_result(result);
        //Fermeture de MySQL
        mysql_close(&mysql);
    }
    else
    {
      printf("Une erreur s est produite lors de la connexion à la BDD!\n");
      printf("Voici le message d'erreur : %s\n\n",mysql_error(&mysql));
    }

    return 0;
}

#endif
